/*
 * Decompiled with CFR 0.152.
 */
package io.github.nocomment1105.deepslatecutting.config;

import io.github.nocomment1105.deepslatecutting.DeepslateCuttingMain;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Properties;

public class Config {
    public static final String COMMENT = "This file stores the config option for DeepslateCutting";
    private static boolean enableExtras;
    private static Path propertiesPath;

    public Config(Path propertiesPath) {
        enableExtras = false;
        Config.propertiesPath = propertiesPath;
    }

    public void init() throws IOException {
        this.load();
        if (!Files.exists(propertiesPath, new LinkOption[0])) {
            Config.save();
        }
    }

    public boolean areExtrasEnabled() {
        try {
            this.load();
        }
        catch (IOException e) {
            DeepslateCuttingMain.LOGGER.error("Failed to initialise DeepslateCutting configuration, default values will be used instead");
            DeepslateCuttingMain.LOGGER.error("", (Throwable)e);
        }
        return enableExtras;
    }

    public void load() throws IOException {
        if (!Files.exists(propertiesPath, new LinkOption[0])) {
            return;
        }
        Properties properties = new Properties();
        properties.load(Files.newInputStream(propertiesPath, new OpenOption[0]));
        enableExtras = "true".equals(properties.getProperty("enableExtras"));
    }

    public static void save() throws IOException {
        Properties properties = new Properties();
        properties.setProperty("enableExtras", enableExtras ? "true" : "false");
        properties.store(Files.newOutputStream(propertiesPath, new OpenOption[0]), COMMENT);
    }

    public static void update(Path path, boolean newValue) throws IOException {
        Properties properties = new Properties();
        properties.load(Files.newInputStream(path, new OpenOption[0]));
        properties.setProperty("enableExtras", newValue ? "true" : "false");
        properties.store(Files.newOutputStream(path, new OpenOption[0]), COMMENT);
    }

    static {
        propertiesPath = null;
    }
}

